-- View: public.v_pdv_consld_vd_nfce

-- DROP VIEW public.v_pdv_consld_vd_nfce;

CREATE OR REPLACE VIEW public.v_pdv_consld_vd_nfce AS 
 SELECT venda.cd_emp,
    venda.cd_filial,
    venda.dt_vd,
    venda.cd_cx,
    sum(venda.nr_coo_ini) AS nr_coo_ini,
    sum(venda.nr_coo_fin) AS nr_coo_fin,
    sum(venda.vl_vd_prod) AS vl_vd_prod,
    sum(venda.vl_vd_serv) AS vl_vd_serv,
    sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
   FROM ( SELECT consolid.cd_emp,
            consolid.cd_filial,
            consolid.dt_vd,
            consolid.cd_cx,
            ( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
            ( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
            sum(consolid.vndprod) AS vl_vd_prod,
            sum(consolid.vndserv) AS vl_vd_serv,
            sum(consolid.naofiscal) AS vl_vd_nfiscal
           FROM ( SELECT vd.cd_emp,
                    vd.cd_filial,
                    vd.dt_vd,
                    vd.cd_cx,
                    vd.nr_ecf,
                    vd.vlr_liq_vd,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
                    0.00 AS naofiscal,
                    0 AS tipovenda
                   FROM pdv_vd vd
                  WHERE vd.st_vd = 0::numeric
                UNION ALL
                 SELECT pdv_cupom_nao_fiscal.cd_emp,
                    pdv_cupom_nao_fiscal.cd_filial,
                    pdv_cupom_nao_fiscal.dt_cupom,
                    pdv_cupom_nao_fiscal.cd_cx,
                    pdv_cupom_nao_fiscal.nr_coo,
                    0 AS vlr_liq_vd,
                    0 AS vndprod,
                    0 AS vndserv,
                    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
                    1 AS tipovenda
                   FROM pdv_cupom_nao_fiscal
                  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom = 1::numeric) consolid
          GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;

ALTER TABLE public.v_pdv_consld_vd_nfce
  OWNER TO postgres;
